#pragma once
#include "Service.h"
#include "Cmd.h"
#include "ConfigSMS.h"
#include "SMSCodec.h"
#include "CharSetString.h"

////////////////////////////////////////////////////////////////////////////
#define  kSmsMEFailure								300
#define  kSmsServiceOfMEReserved					301
#define  kSmsoperationNotAllowed					302
#define  kSmsoperationNotSupported					303
#define  kSmsinvalidPDUModeParameter				304
#define  kSmsinvalidTextModeParameter				305
#define  kSmsSIMNotInserted							310
#define  kSmsSIMPINRrequired						311
#define  kSmsPHSIMPINRequired						312
#define  kSmsSIMFailure								313
#define  kSmsSIMBusy								314
#define  kSmsSIMWrong								315
#define  kSmsSIMPUKRequired							316
#define  kSmsSIMPIN2Required						317
#define  kSmsSIMPUK2Required						318
#define  kSmsmemoryFailure							320
#define  kSmsinvalidMemoryIndex						321
#define  kSmsmemoryFull								322
#define  kSmsSMSCAddressUnknown						330
#define  kSmsnoNetworkService						331
#define  kSmsnetworkTimeout							332
#define  kSmsnoCNMAAcknowledgementExpected			340
#define  kSmsunknownError							500
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
////////////////////////////////////////////////////////////////////////////

class DLLMANAGER_API CServiceSMS :
	public CService
{
public:
	CServiceSMS(void);
	CServiceSMS(CDllManager* iDllManager);
	virtual ~CServiceSMS(void);
	virtual Bool Dispatch(CCmd* iCmdP);
	virtual void OnConfigChange(int iConfigID);
	virtual Bool ProcessData(CDataMessage* iData);
    
	virtual Bool CMGS(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CMGW(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CMGR(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CMGL(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CPMS(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CNMI(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CMGF(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CSCA(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CGSMS(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CMGD(CCmd* iCmdP, Bool iSilentMode=0);
	virtual Bool CMSS(CCmd* iCmdP, Bool iSilentMode=0);

private:	
	char mPDU[1024];
	int mPDULength;
	typedef enum
	{
		StoreSmsToSendBuf = 0,
		StoreSmsInMem2,
	};
	UINT mTmpStat;
	UINT mPDUDestination;

	
};
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////